// Does that spiffy effect when a battle starts
function battleEffect(battle)
{
	RenderMap();
	var map = GrabImage(0, 0, 320, 240);
	var color = CreateColor(255, 255, 255, 128);
	var time = GetTime();
	var scale = 1;
	var degree = 0;
	var degree2 = 0;
	var degree3 = 0;
	var degree4 = 0;
	var counter = 0;
	var phase = 0;
	while (phase < 2)
	{
		switch (phase)
		{
			case 0:
				RenderMap();
				zoomBlitMask(map, 160 - (320 * (scale * 1) / 2), 120 - (240 * (scale * 1) / 2), scale * 1, color);
				zoomBlitMask(map, 160 - (320 * (scale * 1.02) / 2), 120 - (240 * (scale * 1.02) / 2), scale * 1.02, color);
				zoomBlitMask(map, 160 - (320 * (scale * 1.06) / 2), 120 - (240 * (scale * 1.06) / 2), scale * 1.06, color);
				zoomBlitMask(map, 160 - (320 * (scale * 1.12) / 2), 120 - (240 * (scale * 1.12) / 2), scale * 1.12, color);
				break;
			case 1:
				battle.drawGraphics();
				map.blitMask(0, 0, color);
				zoomRotateBlitMask(map, 160 - (320 * (scale * 1) / 2), 120 - (240 * (scale * 1) / 2), scale * 1, dtr(degree4), color);
				zoomRotateBlitMask(map, 160 - (320 * (scale * 1.02) / 2), 120 - (240 * (scale * 1.02) / 2), scale * 1.02, dtr(degree3), color);
				zoomRotateBlitMask(map, 160 - (320 * (scale * 1.06) / 2), 120 - (240 * (scale * 1.06) / 2), scale * 1.06, dtr(degree2), color);
				zoomRotateBlitMask(map, 160 - (320 * (scale * 1.12) / 2), 120 - (240 * (scale * 1.12) / 2), scale * 1.12, dtr(degree), color);
				map = GrabImage(0, 0, 320, 240);
				break;
		}
		FlipScreen();
		var updates = Math.floor((GetTime() - time) / (50 / 3));
		if (updates > 0)
		{
			counter += updates;
			time = GetTime();
			switch (phase)
			{
				case 0:
					scale += .03;
					if (counter > 20)
					{
						phase = 1;
						counter = 0;
						color.alpha = 200;
					}
					UpdateMapEngine();
					RenderMap();
					map = GrabImage(0, 0, 320, 240);
					break;
				case 1:
					if (color.alpha - 8 >= 0)
					{
						color.alpha -= 8;
					}
					else
						color.alpha = 0;
					scale -= .04;
					degree += 3;
					degree2 += 6;
					degree3 += 9;
					degree4 += 12;
					if (counter > 60)
					{
						phase = 2;
					}
					break;
			}
		}
	}
}

function dtr(degree)
{
	if (degree < 0)
	{
		return Math.PI * (360 + degree) / 180;
	}
	else
	{
		return Math.PI * degree / 180;
	}
}

function zoomBlitMask(image, x, y, scale, mask)
{
	image.transformBlitMask(x, y, x + (scale * image.width), y, x + (scale * image.width), y + (scale * image.height), x, y + (scale * image.height), mask);
}

// All the rotate functions were adapted *coughstolencough* from the sphere source for rotating images
function zoomRotateBlit(image, x, y, scale, radians)
{
	var w = scale * image.width;
	var h = scale * image.height;
	var r = Math.sqrt(w * w + h * h) / 2;

    // various useful angles
    var PI = 3.1415927;
    var angle = Math.atan(w / h);  // h shouldn't be zero...
    var upper_left_angle  = -angle;
    var upper_right_angle = angle;
    var lower_right_angle = PI - angle;
    var lower_left_angle  = PI + angle;

    // center of the image
    var cx = x + w / 2;
    var cy = y + h / 2;

    var tx = new Array(cx + r * Math.sin(upper_left_angle  + radians), cx + r * Math.sin(upper_right_angle + radians), cx + r * Math.sin(lower_right_angle + radians), cx + r * Math.sin(lower_left_angle  + radians));

    // I'm not sure why we're doing subtraction here...
    // one of those "just smile and nod" things
    var ty = new Array(cy - r * Math.cos(upper_left_angle  + radians), cy - r * Math.cos(upper_right_angle + radians), cy - r * Math.cos(lower_right_angle + radians), cy - r * Math.cos(lower_left_angle  + radians));

	image.transformBlit(tx[0], ty[0], tx[1], ty[1], tx[2], ty[2], tx[3], ty[3]);
}

function rotateBlitMask(image, x, y, radians, mask)
{
	var w = image.width;
	var h = image.height;
	var r = Math.sqrt(w * w + h * h) / 2;

    // various useful angles
    var PI = 3.1415927;
    var angle = Math.atan(w / h);  // h shouldn't be zero...
    var upper_left_angle  = -angle;
    var upper_right_angle = angle;
    var lower_right_angle = PI - angle;
    var lower_left_angle  = PI + angle;

    // center of the image
    var cx = x + w / 2;
    var cy = y + h / 2;

    var tx = new Array(cx + r * Math.sin(upper_left_angle  + radians), cx + r * Math.sin(upper_right_angle + radians), cx + r * Math.sin(lower_right_angle + radians), cx + r * Math.sin(lower_left_angle  + radians));

    // I'm not sure why we're doing subtraction here...
    // one of those "just smile and nod" things
    var ty = new Array(cy - r * Math.cos(upper_left_angle  + radians), cy - r * Math.cos(upper_right_angle + radians), cy - r * Math.cos(lower_right_angle + radians), cy - r * Math.cos(lower_left_angle  + radians));

	image.transformBlitMask(tx[0], ty[0], tx[1], ty[1], tx[2], ty[2], tx[3], ty[3], mask);
}

function zoomRotateBlitMask(image, x, y, scale, radians, mask)
{
	var w = scale * image.width;
	var h = scale * image.height;
	var r = Math.sqrt(w * w + h * h) / 2;

    // various useful angles
    var PI = 3.1415927;
    var angle = Math.atan(w / h);  // h shouldn't be zero...
    var upper_left_angle  = -angle;
    var upper_right_angle = angle;
    var lower_right_angle = PI - angle;
    var lower_left_angle  = PI + angle;

    // center of the image
    var cx = x + w / 2;
    var cy = y + h / 2;

    var tx = new Array(cx + r * Math.sin(upper_left_angle  + radians), cx + r * Math.sin(upper_right_angle + radians), cx + r * Math.sin(lower_right_angle + radians), cx + r * Math.sin(lower_left_angle  + radians));

    // I'm not sure why we're doing subtraction here...
    // one of those "just smile and nod" things
    var ty = new Array(cy - r * Math.cos(upper_left_angle  + radians), cy - r * Math.cos(upper_right_angle + radians), cy - r * Math.cos(lower_right_angle + radians), cy - r * Math.cos(lower_left_angle  + radians));

	image.transformBlitMask(tx[0], ty[0], tx[1], ty[1], tx[2], ty[2], tx[3], ty[3], mask);
}